 ; Ŀ
 ;   Water - write a lisp file to create a series of grdraw vectors        
 ;   using selected entities as a pattern.                                 
 ;   Copyright 1995, 2004, 2006 by Rocket Software Ltd.                    
 ;   Requires Puss.lsp to be available unless the set of entities to be    
 ;   made into the lisp contains only lines.                               
 ;   Appliance taxidermy - fad of the 2010s.                               
 ; 

 ; Ŀ
 ;   Absolu - write a lisp file to create a series of grdraw vectors       
 ;   using selected lines as a pattern.                                    
 ;   Arguments: Fn, a file handle.                                         
 ;              Lspnam, the function name.                                 
 ;              Ss, The selection set of line entities.                    
 ;   Returns nothing, writes a file, then gets drunk.                      
 ; 
 (DEFUN ABSOLU (fn lspnam ss / num entt ten elv colo llist grlist len sub)
  (setq num 0)
  (while (and ss (setq entt (ssname ss num)))
         (setq entt (entget entt))
         (setq num (1+ num))
         (setq ten (cdr (assoc 10 entt)))
         (setq elv (cdr (assoc 11 entt)))
         (if (null (setq colo (cdr (assoc 62 entt))))
             (setq colo 0))
         (setq llist (append llist (list (list ten elv colo)))))
 ; Ŀ
 ;   Write the code.                                                       
 ; 
  (write-line (strcat " (DEFUN C:" lspnam " (/ grlist num sub)") fn)
  (write-line "  (setq grlist (list " fn)
  (setq len (length llist))
  (setq num 0)
  (while (setq sub (nth num llist))
         (setq num (1+ num))
         (if (/= num len)
             (write-line (strcat "  " (ptos sub)) fn)
             (write-line (strcat "  " (ptos sub) "))") fn)))
  (write-line "  (setq num 0)" fn)
  (write-line "  (while (setq sub (nth num grlist))" fn)
  (write-line "         (grdraw (car sub) (cadr sub) (caddr sub))" fn)
  (write-line "         (setq num (1+ num)))" fn)
  (write-line " (princ))" fn)
  (close fn)
 (princ))
 ; Ŀ
 ;   Absolu end.                                                           
 ; 

 ; Ŀ
 ;   Cenati: write a centred grdraw lisp subroutine.                       
 ;   Arguments: Fn, a file handle.                                         
 ;              Lspnam, the function name.                                 
 ;              Ss, The selection set of line entities.                    
 ;              Ctr, The grdraw base point.                                
 ;   Returns nothing, writes a file.                                       
 ; 
 (DEFUN CENATI (fn lspnam ss ctr / scrsz vwhr vhh hwid minx miny minz num entt
                 ten elv colo llist prevhx prevhy xratio yratio grlist len sub)
  (setq scrsz (getvar "screensize"))       ; view height & width (pixels)
  (setq vwhr (/ (car scrsz) (cadr scrsz))) ; view width/height ratio
  (setq vhh (* (getvar "viewsize") 0.5))   ; view half height in drawing units
  (setq hwid (* vhh vwhr))                 ; view half width

  (setq ctrx (car ctr))
  (setq ctry (cadr ctr))
  (setq ctrz (caddr ctr))
 ; Ŀ
 ;   Extract data from the selection set of lines.                         
 ; 
  (setq num 0)
  (while (and ss (setq entt (ssname ss num)))
         (setq entt (entget entt))
         (setq num (1+ num))
         (setq ten (cdr (assoc 10 entt)))
         (setq elv (cdr (assoc 11 entt)))
         (if (null (setq colo (cdr (assoc 62 entt))))
             (setq colo 0))
 ; Ŀ
 ;   Change points to offsets from the centre point Ctr.                   
 ; 
         (setq ten (list (- (car ten) ctrx)
                         (- (cadr ten) ctry)
                         (- (caddr ten) ctrz)))
         (setq elv (list (- (car elv) ctrx)
                         (- (cadr elv) ctry)
                         (- (caddr elv) ctrz)))
 ; Ŀ
 ;   And add them to the list.                                             
 ; 
         (setq llist (append llist (list (list ten elv colo)))))
 ; Ŀ
 ;   Write the lisp file.                                                  
 ;   Want to calculate the ratio between the old and new screen sizes so   
 ;   that the new size will be the same as the old relative to the         
 ;   screen size.  Then multiply by the scale factor to enlarge or         
 ;   reduce the image.                                                     
 ; 
  (write-line (strcat " (DEFUN " lspnam
 " (pa scal / prevhx prevhy scrsz vwhr vhh hwid xratio yratio pax pay paz") fn)
  (write-line (strcat "                                                "
                      "grlist num sub ten elv colo)") fn)
  (write-line (strcat "  (setq prevhx " (rtos hwid 2) ")") fn)
  (write-line (strcat "  (setq prevhy " (rtos vhh 2) ")") fn)
  (write-line "  (setq scrsz (getvar \"screensize\"))" fn)
  (write-line "  (setq vwhr (/ (car scrsz) (cadr scrsz)))" fn)
  (write-line "  (setq vhh (* (getvar \"viewsize\") 0.5))" fn)
  (write-line "  (setq hwid (* vhh vwhr))" fn)
  (write-line "  (setq xratio (/ hwid prevhx))" fn)
  (write-line "  (setq yratio (/ vhh prevhy))" fn)
  (write-line "  (setq xratio (eval (list min xratio yratio)))" fn)
  (write-line "  (setq xratio (* xratio scal))" fn)
  (write-line "  (setq pax (car pa))" fn)
  (write-line "  (setq pay (cadr pa))" fn)
  (write-line "  (setq paz (caddr pa))" fn)
 ; Ŀ
 ;   Make the points list.                                                 
 ; 
  (write-line "  (setq grlist (list " fn)
  (setq len (length llist))
  (setq num 0)
  (while (setq sub (nth num llist))
         (setq num (1+ num))
         (if (/= num len)
             (write-line (strcat "  " (ptos sub)) fn)
             (write-line (strcat "  " (ptos sub) "))") fn)))
 ; Ŀ
 ;   And write the list interpreter code.                                  
 ; 
  (write-line "  (setq num 0)" fn)
  (write-line "  (while (setq sub (nth num grlist))" fn)
  (write-line "         (setq ten (car sub))" fn)
  (write-line "         (setq elv (cadr sub))" fn)
  (write-line "         (setq colo (caddr sub))" fn)
  (write-line "         (setq ten (list (+ (* xratio (car ten)) pax)" fn)
  (write-line "                         (+ (* xratio (cadr ten)) pay)" fn)
  (write-line "                         (+ (* xratio (caddr ten)) paz)))" fn)
  (write-line "         (setq elv (list (+ (* xratio (car elv)) pax)" fn)
  (write-line "                         (+ (* xratio (cadr elv)) pay)" fn)
  (write-line "                         (+ (* xratio (caddr elv)) paz)))" fn)
  (write-line "         (grdraw ten elv colo)" fn)
  (write-line " ;       (grdraw ten '(0 0) colo)  ; ghosting effect" fn)
  (write-line "         (setq num (1+ num)))" fn)
  (write-line " (princ))" fn)
  (close fn)
 (princ))
 ; Ŀ
 ;   Cenati end.                                                           
 ; 

 ; Ŀ
 ;   Fnang: get a filename, open it, return the name and handle.           
 ;   Takes no arguments, calls nothing, returns a list of the two things.  
 ;   Collects postcards with pictures of trout.                            
 ; 
 (DEFUN FNANG (/ filnam ll ch lspnam quipt handle)
  (setq filnam (getstring "\nLisp name <Fdap>: "))
  (if (= filnam "") (setq filnam "fdap.lsp"))
 ; Ŀ
 ;   See if the file name includes an extension.                           
 ; 
  (setq ll (strlen filnam))
  (while (and (null ch) (< 0 ll) (/= (substr filnam ll 1) (chr 92)))
         (if (= (substr filnam ll 1) ".")
             (setq ch T))
         (setq ll (1- ll)))
 ; Ŀ
 ;   Make the file name and the lisp name.                                 
 ; 
  (if (null ch)
      (progn
           (setq lspnam filnam)
           (setq filnam (strcat filnam ".lsp")))
      (setq lspnam (substr filnam 1 ll)))
 ; Ŀ
 ;   See if the file exists.                                               
 ; 
  (if (findfile filnam)
      (progn
           (initget 0 "Overwrite Append Quit")
           (setq quipt (getkword (strcat
                         "That file already exists."
                         "  Overwrite, Append, or <Quit>? ")))
           (if (null quipt) (setq quipt "Quit"))))
  (cond ((or (null quipt)
             (= quipt "Append"))
         (setq handle (open filnam "a"))
         (if (null handle)
             (write-line "Unable to open that file")))
        ((= quipt "Overwrite")
         (setq handle (open filnam "w"))
         (close handle)
         (setq handle (open filnam "a"))
         (if (null handle)
             (write-line "Unable to open that file")))
        ((= quipt "Quit")
         (exit)))
 ; Ŀ
 ;   Return the captured information.                                      
 ; 
 (list handle lspnam))
 ; Ŀ
 ;   Fnang end.                                                            
 ; 

 ; Ŀ
 ;   Nacl - Explode entities to lines, reinsert.                           
 ;   Arguments: Ss, a set of entities.                                     
 ;   Calls Puss, which has to be available.                                
 ;   Returns nothing.                                                      
 ; 
 (DEFUN NACL (ss / len fnam slist ll ur aaa bbb mlist nll nur scal enam num)
  (setvar "wmfbkgnd" 0)
  (setvar "wmfforegnd" 0)
 ; Ŀ
 ;   Make a directory path and default name string, get a name.            
 ; 
  (setq fnam (strcat (getvar "dwgprefix") (getvar "dwgname")))
  (if (= (substr (strcase fnam t) (- (setq len (strlen fnam)) 3)) ".dwg")
      (setq fnam (substr fnam 1 (- len 4))))
 ; Ŀ
 ;   Find the box bounding the entities.  Theoretically.                   
 ;   Pussy returns a list: (xmax xmin ymax ymin).                          
 ; 
  (if (not pussy) (load "puss"))
  (setq slist (pussy ss))
  (setq ll (list (cadr slist) (cadddr slist)))
  (setq ur (list (car slist) (caddr slist)))
 ; Ŀ
 ;   Find the last entity, save its ename.                                 
 ; 
  (setq aaa (entlast))
  (while (setq bbb (entnext aaa))
         (setq aaa bbb))
 ; Ŀ
 ;   Export the ss to a wmf file.                                          
 ; 
  (command ".export" fnam ss "")
 ; Ŀ
 ;   Erase the original entities.                                          
 ; 
  (command ".erase" ss "")
 ; Ŀ
 ;   Import the wmf file, explode it.                                      
 ; 
  (command ".wmfin" fnam "0,0" "" "" "")
  (command ".explode" (entlast))
 ; Ŀ
 ;   Get an ss of the new entities.                                        
 ; 
  (setq ss (smack aaa))
 ; Ŀ
 ;   Find the box bounding them.                                           
 ; 
  (setq mlist (pussy ss))
  (setq nll (list (cadr mlist) (cadddr mlist)))
  (setq nur (list (car mlist) (caddr mlist)))
 ; Ŀ
 ;   Move the lower left corner of the new entities to the lower left      
 ;   corner of the old.                                                    
 ; 
  (command ".move" ss "" nll ll)
 ; Ŀ
 ;   Scale them to match the now departed original stuff.                  
 ; 
  (setq scal (/ (distance ll ur) (distance nll nur)))
  (command ".scale" ss "" ll scal)
 ; Ŀ
 ;   Explode them - some will probably be polylines.                       
 ; 
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         (command ".explode" enam))
 ; Ŀ
 ;   Clean up and go home.                                                 
 ; 
  (command ".redraw")
 (princ))
 ; Ŀ
 ;   Nacl end.                                                             
 ; 

 ; Ŀ
 ;   Ptos - convert a list of two point lists to a string.                 
 ;   Argument: Plist, a list of two three number lists and a number:       
 ;                    ((n n n) (n n n) n)                                  
 ;   Returns a string.                                                     
 ;   The point of this is that (rtos 0.5 2) returns ".5", which means      
 ;   that this: (0.5 1 1) converts to "(.5 1 1)" which when read from      
 ;   a file will crash on loading.                                         
 ;   -.5 is okay, but will future versions be okay with it?                
 ; 
 (DEFUN PTOS (plist / colo mastr sub nustr suba stra)
  (setq colo (itoa (car (reverse plist))))
  (setq plist (reverse (cdr (reverse plist))))
  (setq mastr "(")
  (while (setq sub (car plist))
         (setq plist (cdr plist))
         (setq nustr "(")
         (while (setq suba (car sub))
                (setq sub (cdr sub))
                (setq stra (rtos suba 2 4))
                (cond ((= (substr stra 1 1) ".")
                       (setq stra (strcat "0" stra)))
                      ((= (substr stra 1 2) "-.")
                       (setq stra (strcat "-0." (substr stra 3)))))
                (if (= (strlen nustr) 1)
                    (setq nustr (strcat nustr stra))
                    (setq nustr (strcat nustr " " stra))))
         (setq nustr (strcat nustr ")"))
         (if (= (strlen mastr) 1)
             (setq mastr (strcat mastr nustr))
             (setq mastr (strcat mastr " " nustr))))
  (setq mastr (strcat "'" mastr " " colo ")"))
 mastr)
 ; Ŀ
 ;   Ptos end.                                                             
 ; 

 ; Ŀ
 ;   Relati: write a grdraw lisp.                                          
 ;   Arguments: Fn, a file handle.                                         
 ;              Lspnam, the function name.                                 
 ;              Ss, The selection set of line entities.                    
 ;   Returns nothing, writes a file.                                       
 ; 
 (DEFUN RELATI (fn lspnam ss ctr / scrsz vwhr vhh hwid minx miny minz num entt
                 ten elv colo llist prevhx prevhy xratio yratio grlist len sub)
 ; Ŀ
 ;   Find out where the current view is, and how big.                      
 ; 
  (setq scrsz (getvar "screensize"))       ; view height & width (pixels)
  (setq vwhr (/ (car scrsz) (cadr scrsz))) ; view width/height ratio
  (setq vhh (* (getvar "viewsize") 0.5))   ; view half height in drawing units
  (setq hwid (* vhh vwhr))                 ; view half width
  (setq minx (- (car ctr) hwid))
  (setq miny (- (cadr ctr) vhh))
  (setq minz (caddr ctr))
 ; Ŀ
 ;   Extract data from the selection set of lines.                         
 ; 
  (setq num 0)
  (while (and ss (setq entt (ssname ss num)))
         (setq entt (entget entt))
         (setq num (1+ num))
         (setq ten (cdr (assoc 10 entt)))
         (setq elv (cdr (assoc 11 entt)))
         (if (null (setq colo (cdr (assoc 62 entt))))
             (setq colo 0))
 ; Ŀ
 ;   Change points to offset from lower left of current view.              
 ; 
         (setq ten (list (- (car ten) minx)
                         (- (cadr ten) miny)
                         (- (caddr ten) minz)))
         (setq elv (list (- (car elv) minx)
                         (- (cadr elv) miny)
                         (- (caddr elv) minz)))
 ; Ŀ
 ;   And add them to the list.                                             
 ; 
         (setq llist (append llist (list (list ten elv colo)))))
 ; Ŀ
 ;   Write the lisp file.                                                  
 ; 
  (write-line (strcat " (DEFUN C:" lspnam
         " (/ prevhx prevhy scrsz vwhr ctr vhh hwid xratio yratio minx") fn)
  (write-line (strcat "                                                  "
                      "miny grlist num sub ten elv)") fn)
  (write-line (strcat "  (setq prevhx " (rtos hwid 2) ")") fn)
  (write-line (strcat "  (setq prevhy " (rtos vhh 2) ")") fn)
  (write-line "  (setq scrsz (getvar \"screensize\"))" fn)
  (write-line "  (setq vwhr (/ (car scrsz) (cadr scrsz)))" fn)
  (write-line "  (setq ctr (getvar \"viewctr\"))" fn)
  (write-line "  (setq vhh (* (getvar \"viewsize\") 0.5))" fn)
  (write-line "  (setq hwid (* vhh vwhr))" fn)
  (write-line "  (setq xratio (/ hwid prevhx))" fn)
  (write-line "  (setq yratio (/ vhh prevhy))" fn)
  (write-line "  (setq minx (- (car ctr) hwid))" fn)
  (write-line "  (setq miny (- (cadr ctr) vhh))" fn)
  (write-line "  (setq minz (- (caddr ctr) hwid))" fn)
  (write-line "  (setq grlist (list " fn)
  (setq len (length llist))
  (setq num 0)
 ; Ŀ
 ;   Make the points list.                                                 
 ; 
  (while (setq sub (nth num llist))
         (setq num (1+ num))
         (if (/= num len)
             (write-line (strcat "  " (ptos sub)) fn)
             (write-line (strcat "  " (ptos sub) "))") fn)))
 ; Ŀ
 ;   And write the list interpreter code.                                  
 ; 
  (write-line "  (setq num 0)" fn)
  (write-line "  (while (setq sub (nth num grlist))" fn)
  (write-line "         (setq ten (car sub))" fn)
  (write-line "         (setq elv (cadr sub))" fn)
  (write-line "         (setq colo (caddr sub))" fn)
  (write-line "         (setq ten (list (+ (* xratio (car ten)) minx)" fn)
  (write-line "                         (+ (* yratio (cadr ten)) miny)" fn)
  (write-line "                         (+ (* xratio (caddr ten)) minz)))" fn)
  (write-line "         (setq elv (list (+ (* xratio (car elv)) minx)" fn)
  (write-line "                         (+ (* yratio (cadr elv)) miny)" fn)
  (write-line "                         (+ (* xratio (caddr elv)) minz)))" fn)
  (write-line "         (grdraw ten elv colo)" fn)
  (write-line "         (setq num (1+ num)))" fn)
  (write-line " (princ))" fn)
  (close fn)
 (princ))
 ; Ŀ
 ;   Relati end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Smack - make an ss of any entities after a given one.      
 ;   Takes the marker ename as an argument, returns an ss.                 
 ;   Note: this routine looks overly baroque.                              
 ; 
 (DEFUN SMACK (aaa / ss bbb)
  (setq ss (ssadd (setq bbb (entnext aaa)))) ; put next ent in new ss
 ; Ŀ
 ;   If the entity is an insert and has attributes, or is a polyline:      
 ; 
  (if (or (and (= (cdr (assoc 0 (entget bbb))) "INSERT")
               (= (cdr (assoc 66 (entget bbb))) 1))
          (= (cdr (assoc 0 (entget bbb))) "POLYLINE"))
 ; Ŀ
 ;   Then find the seqend before assuming entnext will give the next ent.  
 ; 
      (progn
           (while (/= (cdr (assoc 0 (entget bbb))) "SEQEND")
                  (setq bbb (entnext bbb)))))
 ; Ŀ
 ;   Find all entities after the marker point, put them in an ss.          
 ; 
  (while (entnext bbb)                  ; while there are entities
         (setq bbb (entnext bbb))       ; find the next new entity
         (ssadd bbb ss)                 ; add it to the selection set
         (if (or (and (= (cdr (assoc 0 (entget bbb))) "INSERT")
                      (= (cdr (assoc 66 (entget bbb))) 1))
                 (= (cdr (assoc 0 (entget bbb))) "POLYLINE"))
             (progn
                  (while (/= (cdr (assoc 0 (entget bbb))) "SEQEND")
                         (setq bbb (entnext bbb))))))
  ss)
 ; Ŀ
 ;   Smack end.                                                            
 ; 

 ; Ŀ
 ;   Subu - make a grdraw making subroutine.                               
 ;   Arguments: Fn, a file handle.                                         
 ;              Lspnam, the function name.                                 
 ;              Ss, The selection set of line entities.                    
 ;              Ctr, The grdraw base point.                                
 ;   Returns nothing, writes a file.                                       
 ; 
 (DEFUN SUBU (fn lspnam ss ctr / scrsz vwhr vhh hwid minx miny num entt ten
                    elv colo llist prevhx prevhy xratio yratio grlist len sub)
 ; Ŀ
 ;   Find out where the current view is, and how big.                      
 ; 
  (setq scrsz (getvar "screensize"))       ; view height & width (pixels)
  (setq vwhr (/ (car scrsz) (cadr scrsz))) ; view width/height ratio
  (setq vhh (* (getvar "viewsize") 0.5))   ; view half height in drawing units
  (setq hwid (* vhh vwhr))                 ; view half width
  (setq minx (- (car ctr) hwid))
  (setq miny (- (cadr ctr) vhh))
 ; Ŀ
 ;   Extract data from the selection set of lines.                         
 ; 
  (setq num 0)
  (while (and ss (setq entt (ssname ss num)))
         (setq entt (entget entt))
         (setq num (1+ num))
         (setq ten (cdr (assoc 10 entt)))
         (setq elv (cdr (assoc 11 entt)))
         (if (null (setq colo (cdr (assoc 62 entt))))
             (setq colo 0))
 ; Ŀ
 ;   Change points to offset from lower left of current view.              
 ; 
         (setq ten (list (- (car ten) minx) (- (cadr ten) miny) (caddr ten)))
         (setq elv (list (- (car elv) minx) (- (cadr elv) miny) (caddr elv)))
 ; Ŀ
 ;   And add them to the list.                                             
 ; 
         (setq llist (append llist (list (list ten elv colo)))))
 ; Ŀ
 ;   Write the lisp file.                                                  
 ; 
  (write-line (strcat " (DEFUN " lspnam
            " (ctr / prevhx prevhy scrsz vwhr vhh hwid xratio yratio minx") fn)
  (write-line (strcat "                                                  "
                      "miny grlist num sub ten elv)") fn)
  (write-line (strcat "  (setq prevhx " (rtos hwid 2) ")") fn)
  (write-line (strcat "  (setq prevhy " (rtos vhh 2) ")") fn)
  (write-line "  (setq scrsz (getvar \"screensize\"))" fn)
  (write-line "  (setq vwhr (/ (car scrsz) (cadr scrsz)))" fn)
  (write-line "  (setq vhh (* (getvar \"viewsize\") 0.5))" fn)
  (write-line "  (setq hwid (* vhh vwhr))" fn)
  (write-line "  (setq xratio (/ hwid prevhx))" fn)
  (write-line "  (setq yratio (/ vhh prevhy))" fn)
  (write-line "  (setq minx (- (car ctr) hwid))" fn)
  (write-line "  (setq miny (- (cadr ctr) vhh))" fn)
  (write-line "  (setq grlist (list " fn)
  (setq len (length llist))
  (setq num 0)
 ; Ŀ
 ;   Make the points list.                                                 
 ; 
  (while (setq sub (nth num llist))
         (setq num (1+ num))
         (if (/= num len)
             (write-line (strcat "  " (ptos sub)) fn)
             (write-line (strcat "  " (ptos sub) "))") fn)))
 ; Ŀ
 ;   And write the list interpreter code.                                  
 ; 
  (write-line "  (setq num 0)" fn)
  (write-line "  (while (setq sub (nth num grlist))" fn)
  (write-line "         (setq ten (car sub))" fn)
  (write-line "         (setq elv (cadr sub))" fn)
  (write-line "         (setq colo (caddr sub))" fn)
  (write-line "         (setq ten (list (+ (* xratio (car ten)) minx)" fn)
  (write-line "                         (+ (* yratio (cadr ten)) miny)))" fn)
  (write-line "         (setq elv (list (+ (* xratio (car elv)) minx)" fn)
  (write-line "                         (+ (* yratio (cadr elv)) miny)))" fn)
  (write-line "         (grdraw ten elv colo)" fn)
  (write-line "         (setq num (1+ num)))" fn)
  (write-line " (princ))" fn)
  (close fn)
 (princ))
 ; Ŀ
 ;   Subu end.                                                             
 ; 

 ; Ŀ
 ;   Water.                                                                
 ; 
 (DEFUN C:WATER (/ osna lspnam handle ss ss1 len1 len aaa bbb insp pap pa)
  (command ".undo" "be")
  (setq osna (getvar "osmode"))
  (setvar "osmode" 0)
 ; Ŀ
 ;   Get a lisp name and a file handle.                                    
 ; 
  (setq handle (fnang))
  (setq lspnam (cadr handle))
  (setq handle (car handle))
 ; Ŀ
 ;   Now ask for pattern lines.                                            
 ; 
  (write-line "Select entities to process: ")
  (if (setq ss (ssget))
      (setq ss1 (ssget "p" (list (cons 0 "LINE")))))
  (if ss1 (setq len1 (sslength ss1)))
 ; Ŀ
 ;   If anything in the ss is not a line then call NaCl to explode the     
 ;   entire ss into lines.  This will also flatten them unless the wmf     
 ;   file format contains some unexpected 3D information.                  
 ; 
  (if (and ss
           (> (setq len (sslength ss)) 0)
           (/= len len1))
      (progn
 ; Ŀ
 ;   Find the last entity, save its ename.                                 
 ; 
           (setq aaa (entlast))
           (while (setq bbb (entnext aaa))
                  (setq aaa bbb))
 ; Ŀ
 ;   Monstro-explode everything in the ss.                                 
 ; 
           (nacl ss)
 ; Ŀ
 ;   Get an ss of the new entities.                                        
 ; 
           (setq ss (smack aaa))))
 ; Ŀ
 ;   Ask how to write the Lisp file.                                       
 ; 
  (initget 0 "Relative Absolute Make Subroutine Centred")
  (if handle
      (progn
           (Setq insp (getkword
      "Draw vectors Absolute/Make Subroutine/Centred subroutine/<Relative>: "))
 ; Ŀ
 ;   Make a subroutine to redraw the image scaled relative to screen size  
 ;   and always in the same location on the screen.                        
 ; 
           (cond ((or (null insp) (= insp "Relative"))
                  (setq pap (getvar "viewctr"))  ; centre point of screen
                  (if (null (setq pa (getpoint pap
                                          "Insertion point or <Return>: ")))
                      (setq pa pap))
                  (relati handle lspnam ss pa))
 ; Ŀ
 ;   Absolute.                                                             
 ; 
                 ((= insp "Absolute")
                  (absolu handle lspnam ss))
 ; Ŀ
 ;   As a subroutine which accepts a scale and a basepoint, the basepoint  
 ;   of the graphic being specified here by the user.                      
 ; 
                 ((= insp "Centred")
                  (setq pap (getvar "viewctr"))  ; centre point of screen
                  (if (null (setq pa (getpoint pap
                                              "Base point or <Return>: ")))
                      (setq pa pap))
                  (cenati handle lspnam ss pa))
 ; Ŀ
 ;   Relative to screen size and a specified basepoint, write code to      
 ;   be used as a subroutine with the basepoint as an argument.            
 ; 
                 ((member insp '("Make" "Subroutine"))
                  (setq pap (getvar "viewctr"))  ; centre point of screen
                  (if (null (setq pa (getpoint pap
                                          "Insertion point or <Return>: ")))
                      (setq pa pap))
                  (subu handle lspnam ss pa)))))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (setvar "osmode" osna) 
  (command ".undo" "end")
 (princ))